/*
 * $Id$
 *
 * some common code for *ftex
 *
 */

#include <stdio.h>
#include <string.h>
#include <FreeImage.h>
#include "err.h"

extern int quiet;

void *feedback(float progress, void* foo1, void* foo2)
{
  int mipmap;

  foo2 = foo2;

  if (!quiet) {
    mipmap = *(int *)foo1;
    printf("\r");
    printf("%.1f%% of mipmap %d", progress, mipmap);
    fflush(stdout);
  }
  return NULL;
}

void FreeImageErrorHandler(FREE_IMAGE_FORMAT fif, const char *message) {
  printf("\n*** ");
  printf("%s Format\n", FreeImage_GetFormatFromFIF(fif));
  printf(message);
  printf(" ***\n");
  fflush(stdout);
}

void check_fi_version(void)
{
  char ver[24];

  sprintf(ver, "%d.%d.%d", FREEIMAGE_MAJOR_VERSION, FREEIMAGE_MINOR_VERSION,
  FREEIMAGE_RELEASE_SERIAL);

  if (strcmp(ver, FreeImage_GetVersion()) == 0)
  {
    return;
  } else {
    errx(EXIT_FAILURE, "FreeImage lib version missmatch, built with %s, found %s",
     ver, FreeImage_GetVersion());
  }
}